/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.collect.Multiset;
import org.simmetrics.MultisetDistance;
import org.simmetrics.MultisetMetric;
import org.simmetrics.metrics.Math;

public final class BlockDistance<T>
implements MultisetMetric<T>,
MultisetDistance<T> {
    @Override
    public float compare(Multiset<T> a, Multiset<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        return 1.0f - this.distance(a, b) / (float)(a.size() + b.size());
    }

    @Override
    public float distance(Multiset<T> a, Multiset<T> b) {
        float distance = 0.0f;
        for (Object token : Math.union(a, b).elementSet()) {
            float frequencyInA = a.count(token);
            float frequencyInB = b.count(token);
            distance += java.lang.Math.abs(frequencyInA - frequencyInB);
        }
        return distance;
    }

    public String toString() {
        return "BlockDistance";
    }
}

